#include <windows.h>
#include <string.h>
#include <string>
#include <tchar.h>
#include "resource.h"
#include "bfcounter.h"

#define SAFE_DELETE(p)       { if(p) { delete (p);     (p)=0; } }
#define SAFE_DELETE_ARRAY(p) { if(p) { delete[] (p);   (p)=0; } }
#define ID_HOTKEY 1
#define VK_P      0x50

//#define SAFE_RELEASE(p)      { if(p) { (p)->Release(); (p)=NULL; } }


//O[o萔
static const int INTERVAL		= 100 ;

static const int ID_TIMER		= 1 ;
static const int IDB_START_STOP		= 2 ;
static const int IDE_MAX_COUNT		= 3 ;
static const TCHAR szClassName_[]	= "BFCounter";

//static const int BUFFER_COUNT = 5;
//static BYTE* wavBuffers_[ BUFFER_COUNT] ;
//static BYTE* buffer0 ;
//static BYTE* buffer1 ;
//static BYTE* buffer2 ;
//static BYTE* buffer3 ;
//static BYTE* buffer4 ;


enum MODE {
	RUN, STOP
} ;
//O[oϐ
static	MODE mode_ = STOP ;
static	int initMaxCount_ = 25 ;
static	int maxCount_ = initMaxCount_ ;
static	int currentCount_ = initMaxCount_ ;
static  DWORD lastTime_	= 0 ;

// Instance
HINSTANCE	hInst_ ;
// Mutex
HANDLE hMutex_ ;

// ACR
HICON		hIcon_ ;
HICON		hIconSmall_ ;

//gpWindow
HWND hButtonStartStop_ ;
HWND hEditBoxMaxCount_ ;

LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM) ;


void SetMainWindowText( HWND hWnd) ;

void OnCreate( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) ;
void OnPaint( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam, HDC hdc) ;
void OnClose( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) ;
void OnTimer( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) ;
void OnCommand( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) ;
void OnDestory( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) ;
ATOM RegistWindowClass(HINSTANCE) ;
BOOL InitInstance(HINSTANCE, int) ;

//EBhEENX̓o^

ATOM RegistWindowClass(HINSTANCE hInst)
{

	WNDCLASS		wc ;
	wc.style		= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= WndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInst;
	wc.hIcon		= NULL;
	wc.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= (HBRUSH)GetStockObject(WHITE_BRUSH);
	wc.lpszMenuName		= MAKEINTRESOURCE(IDR_MAINMENU) ;
	wc.lpszClassName	= szClassName_;

	return (RegisterClass(&wc));
}

//EBhE̐

BOOL InitInstance(HINSTANCE hInst, int nCmdShow)
{
    HWND hWnd;

    hWnd = CreateWindow(szClassName_,
        szClassName_,
	WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
        CW_USEDEFAULT,
        CW_USEDEFAULT,
        180,
        80,
        NULL,
        NULL,
        hInst,
        NULL);
    if ( !hWnd) {
        return FALSE ;
    }
	if( !setHook( hWnd)){
		return  FALSE ;
	}


    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    return TRUE;
}

/*
bool GetWaveBuffer()
{
	TCHAR buf[ 300] ;
	//GetCurrentDirectory( MAX_PATH, buf) ;
	//MessageBox( NULL, buf, NULL, NULL) ;
	for( int i = 0 ; i < BUFFER_COUNT ; i ++) {

		FILE* fp ;
		TCHAR filename[ 10] ;
		_stprintf( filename, "%d.wav", i) ;
		fp = _tfopen( filename, "rb") ;
		if( fp == 0) {
			TCHAR mes[ 100] ;
			_stprintf( mes, "%s݂܂BI܂", filename) ;
			MessageBox( NULL, mes, "G[", NULL) ;
			for( int j = 0 ; j < i ; j ++) {
				SAFE_DELETE_ARRAY( wavBuffers_[ j]) ;
			}
			return false ;
		}

		fseek( fp, 0L, SEEK_END) ;
		long size = ftell( fp) ;

		_stprintf( buf, "%d, %d", size, sizeof( BYTE)) ;
		MessageBox( NULL, buf, NULL, NULL) ;
		wavBuffers_[ i] = new BYTE[ size] ;
		fread( wavBuffers_[ i], sizeof( BYTE), size, fp) ;
		fclose( fp) ;
	}
	return true ;

}*/

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpszCmdLine, int nCmdShow)
{
    	MSG msg ;
	BOOL bRet ;

	UNREFERENCED_PARAMETER( hInstance) ;
	UNREFERENCED_PARAMETER( hPrevInstance) ;
	UNREFERENCED_PARAMETER( lpszCmdLine) ;
	UNREFERENCED_PARAMETER( nCmdShow) ;

	hInst_ = hInstance ;

	// dNh~

	hMutex_ = CreateMutex( NULL, FALSE, szClassName_) ;
	if( GetLastError() == ERROR_ALREADY_EXISTS){
		MessageBox( NULL, TEXT("dNł܂"), szClassName_, MB_ICONSTOP | MB_OK) ;
		CloseHandle( hMutex_) ;
		return  0 ;
	}
	/*
	hIcon_ = LoadIcon( hInst_, MAKEINTRESOURCE( IDI_ICON1)) ;
	if( !hIcon_){
		MessageBox( NULL, TEXT( "傫ACR̃[hɎs"), szTitle_, MB_ICONEXCLAMATION | MB_OK) ;
		ReleaseMutex(hMutex_);
		return  0 ;
	}
	hIconSmall_ = (HICON)LoadImage( hInst_, MAKEINTRESOURCE( IDI_ICON1), IMAGE_ICON, 16, 16, 0) ;
	if( !hIconSmall_){
		MessageBox( NULL, TEXT( "ACR̃[hɎs"), szTitle_, MB_ICONEXCLAMATION | MB_OK) ;
		ReleaseMutex(hMutex_);
		return 0 ;
	}*/
	/*
	for( int i = 0 ; i < BUFFER_COUNT ; i ++) {
		wavBuffers_[ i] = 0 ;
	}

	bool result = GetWaveBuffer() ;
	if( !result) {
		// Av̏I
		ReleaseMutex( hMutex_);
		return FALSE ;
	}*/

	if( !RegistWindowClass( hInst_)){
		ReleaseMutex( hMutex_);
		/*
		for( int i = 0 ; i < BUFFER_COUNT ; i ++) {
		SAFE_DELETE_ARRAY( wavBuffers_[ i]) ;
		}*/
		return FALSE ;
	}
	if( !InitInstance( hInst_, nCmdShow)){
		ReleaseMutex( hMutex_);
		/*
		for( int i = 0 ; i < BUFFER_COUNT ; i ++) {
		SAFE_DELETE_ARRAY( wavBuffers_[ i]) ;
		}*/
		return FALSE;
	}
	while( ( bRet = GetMessage(&msg, NULL, 0, 0)) != 0){
		if (bRet == -1) {
			break;
		} else {
			TranslateMessage( &msg) ;
			DispatchMessage( &msg) ;
		}
	}
	// Av̏I
	ReleaseMutex( hMutex_);

	/*for( int i = 0 ; i < BUFFER_COUNT ; i ++) {
		SAFE_DELETE_ARRAY( wavBuffers_[ i]) ;
	}*/

	return (int)msg.wParam ;
}


void SetMainWindowText( HWND hWnd) {
	TCHAR buf2[20] ;
	::_stprintf( buf2, "%2d/%2d(%s)", currentCount_, maxCount_, ::szClassName_) ;
	SetWindowText( hWnd, buf2) ;
}
//EBhEvV[W
LRESULT CALLBACK WndProc( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{

	HDC hdc ;
	PAINTSTRUCT ps;
	switch (msg) {
	case WM_CREATE:
		OnCreate( hWnd, msg, wParam, lParam) ;
		break;
	case WM_TIMER :
		OnTimer( hWnd, msg, wParam, lParam) ;
		break ;
	case WM_PAINT:
		hdc = BeginPaint( hWnd, &ps) ;
		OnPaint( hWnd, msg, wParam, lParam, hdc) ;
		EndPaint( hWnd, &ps) ;
		break ;
	case WM_COMMAND:
		OnCommand( hWnd, msg, wParam, lParam) ;
            break;
	case WM_HOTKEY :
		OnCommand( hWnd, msg, IDB_START_STOP, lParam) ;
		break ;
	case WM_CLOSE:
		OnClose( hWnd, msg, wParam, lParam) ;
		break;
	case WM_DESTROY:
		OnDestory( hWnd, msg, wParam, lParam) ;
		PostQuitMessage( 0) ;
		break;
	default:
		return DefWindowProc( hWnd, msg, wParam, lParam) ;
	}
	return 0;
}


void OnCreate( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
	HINSTANCE hInst = (HINSTANCE)GetWindowLong(hWnd, GWL_HINSTANCE) ;
	hButtonStartStop_ = CreateWindow( TEXT("BUTTON"), TEXT("Start"), WS_CHILD | WS_VISIBLE | BS_PUSHBUTTON, 83, 5, 80, 25, hWnd, (HMENU)IDB_START_STOP, hInst , NULL) ;
	hEditBoxMaxCount_ = CreateWindow( TEXT("edit"), NULL, WS_CHILD | WS_VISIBLE | ES_LEFT | ES_NUMBER | WS_BORDER, 48, 9, 23, 20, hWnd, (HMENU)IDE_MAX_COUNT, hInst, NULL) ;
	TCHAR buf[10] ;
	::_stprintf(buf, "%d", initMaxCount_) ;
	SetWindowText( hEditBoxMaxCount_, buf) ;
	SetMainWindowText( hWnd) ;
//	::timeBeginPeriod( 0) ;
}
void OnDestory( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
//	::timeEndPeriod(0) ;
}
void OnPaint( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam, HDC hdc) {

    TCHAR str_org[] = "%02d / ";
    TCHAR text[256];
    RECT rt;


    wsprintf((LPSTR)text, (LPCSTR)str_org, currentCount_) ;

    SetTextColor(hdc, RGB(255, 0, 0));
    TextOut(hdc, 10, 10, (LPSTR)text, strlen(text));
    SetTextColor(hdc, RGB(0, 0, 255));
}
void OnClose( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
	unsetHook();
	DestroyWindow(hWnd);
}
void OnTimer( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {

	DWORD t = ::timeGetTime() ;

	if( t - lastTime_ >= 1000) {
		lastTime_ +=1000 ;
		if( currentCount_ == 0) {
			currentCount_ = maxCount_ - 1;
			SetMainWindowText( hWnd) ;
			return ;
		}
		else {
			currentCount_ -- ;
			switch( currentCount_) {
				case 4 :
					PlaySound( "4.wav" , 0, SND_ASYNC );
					break ;
				case 3 :
					PlaySound( "3.wav" , 0, SND_ASYNC );
					break ;
				case 2 :
					PlaySound( "2.wav" , 0, SND_ASYNC );
					break ;
				case 1 :
					PlaySound( "1.wav" , 0, SND_ASYNC );
					break ;
				case 0 :
					PlaySound( "0.wav" , 0, SND_ASYNC );
					break ;
			}
			InvalidateRect( hWnd, NULL, NULL) ;
			SetMainWindowText( hWnd) ;
		}

		/*HłȂB
		if( currentCount_ <= 4) {


			PlaySound( (LPCSTR)wavBuffers_[ currentCount_] , 0,SND_MEMORY);
		}*/
	}

}

void OnCommand( HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam) {
	switch(LOWORD(wParam)) {
		case IDM_FILE_END:
			SendMessage(hWnd, WM_CLOSE, 0, 0L);
			break ;
		case IDB_START_STOP :
			switch( mode_) {
				case RUN :
					mode_ = STOP ;
					::SetWindowText( hButtonStartStop_, "Start") ;
					KillTimer( hWnd, ID_TIMER) ;
					currentCount_ = maxCount_ ;
					SetMainWindowText( hWnd) ;
					InvalidateRect( hWnd, NULL, NULL) ;
					break ;
				case STOP :



					TCHAR buf[ 10] ;
					GetWindowText(hEditBoxMaxCount_,buf,sizeof(buf)/sizeof(TCHAR));
					int buflength = ::_tcslen( buf) ;

					bool isbufdigit = true ;
					for( int i = 0 ; i < buflength ; i ++) {
						if( !::isdigit( buf[ i])) {
							::MessageBox( hWnd, "lĂ", "̓G[", NULL) ;
							isbufdigit = false ;
							wsprintf((LPSTR)buf, "%d", maxCount_) ;
							break ;
						}
					}
					if( !isbufdigit) {
						break ;
					}


					int tmpCount = ::_ttoi( buf) ;

					if( tmpCount <= 0) {
						::MessageBox( hWnd, "1ȏ̒lĂ", "̓G[", NULL) ;
						break ;
					}
					maxCount_ = tmpCount ;
					mode_ = RUN ;
					lastTime_ = ::timeGetTime() ;
					::SetWindowText( hButtonStartStop_, "Stop") ;

					currentCount_ = maxCount_ ;
					SetMainWindowText( hWnd) ;

					SetTimer( hWnd, ID_TIMER, INTERVAL, NULL) ;

					break ;


            }
	}
}
